//
//  WXKMailWindowController.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/27.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKMailWindowController.h"


NSString*	kWXKMailPhoneNumberDefaultsKey	= @"WXKMailPhoneNumberDefaultsKey";
NSString*	kWXKMailExportFormatDefaultsKey	= @"WXKMailExportFormatDefaultsKey";

typedef enum {
	WXKMailWindowControllerMboxFileFormat = 0,
	WXKMailWindowControllerRFC822MessageFileFormat,
	WXKMailWindowControllerVMessageFileFormat
} WXKMailWindowControllerFileFormat;


@implementation WXKMailWindowController


+ (void)initialize
{
	[NSDateFormatter setDefaultFormatterBehavior:NSDateFormatterBehavior10_4];
	
    NSUserDefaults	*userDefaults			= [NSUserDefaults standardUserDefaults];
    NSDictionary	*regstrationDictionary	= [NSDictionary dictionaryWithObjectsAndKeys:
		@"07000000000", kWXKMailPhoneNumberDefaultsKey, 
		[NSNumber numberWithInt:0], kWXKMailExportFormatDefaultsKey,
		nil];
    [userDefaults registerDefaults:regstrationDictionary];
}

#pragma mark Initialization and deallocation

- (id)init
{
	NSURL *url = [[self class] URLWithPersistentStoreDirectory:@"Kyopon Utilities" filename:@"mails.wxkxml"];
	
	self = [super initWithWindowNibName:@"MailWindow" URLForPersistentStore:url];
	
	if (self != nil) {
	}
	return self;
}

- (void)windowWillLoad
{
	[super windowWillLoad];
	
	[self setWindowFrameAutosaveName:@"MailWindowFrame"];
	
	NSManagedObjectContext	*context		= [self managedObjectContext];
	NSFetchRequest			*fetchRequest	= [[[NSFetchRequest alloc] init] autorelease];
	NSEntityDescription		*entity			= [NSEntityDescription entityForName:@"MailBox" inManagedObjectContext:context];
	[fetchRequest setEntity:entity];
	
	NSError *fetchError;
	NSArray *fetchResults = [context executeFetchRequest:fetchRequest error:&fetchError];
	if (fetchResults == nil) {
		//
	} else if ([fetchResults count] != 3) {
		[context processPendingChanges];
		[[context undoManager] disableUndoRegistration];
		
		NSEnumerator *enumerator = [fetchResults objectEnumerator];
		NSManagedObject *object;
		while (object = [enumerator nextObject]) {
			[context deleteObject:object];
		}
		
		int i;
		for (i = 1; i <= 3; i++) {
			object = [NSEntityDescription insertNewObjectForEntityForName:@"MailBox" inManagedObjectContext:context];
			[object setValue:[NSNumber numberWithLong:i] forKey:@"order"];
			switch (i) {
				case 1:
					[object setValue:NSLocalizedStringFromTable(@"Sent", @"MailLocalizable", @"mailbox.sent") forKey:@"title"];
					break;
				case 2:
					[object setValue:NSLocalizedStringFromTable(@"Drafts", @"MailLocalizable", @"mailbox.draft") forKey:@"title"];
					break;
				case 3:
					[object setValue:NSLocalizedStringFromTable(@"Inbox", @"MailLocalizable", @"mailbox.inbox") forKey:@"title"];
					break;
			}
		}
		
		[context processPendingChanges];
		[[context undoManager] enableUndoRegistration];
		
	}
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(foldersTableViewSelectionDidChange:)
												 name:NSTableViewSelectionDidChangeNotification
											   object:foldersTableView];
	
	// Since 10.4 style NSDateFormatter cannot be set by Interface Builder, set it manually.
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateStyle:NSDateFormatterMediumStyle];
	[dateFormatter setTimeStyle:NSDateFormatterMediumStyle];
	[[[itemsTableView tableColumnWithIdentifier:@"date"] dataCell] setFormatter:dateFormatter];
	[dateFormatter release];
	
	[self setupToolbarWithIdentifier:@"Mail Utility"];
//	[self setupForDragAndDropOperation];
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:NSTableViewSelectionDidChangeNotification
												  object:foldersTableView];
	
	[super dealloc];
}


#pragma mark Overriding superclass

- (NSString *)localizedItemName
{
	return NSLocalizedStringFromTable(@"mail", @"MailLocalizable", @"localizedItemName");
}

- (NSString *)localizedPluralItemName
{
	return NSLocalizedStringFromTable(@"mails", @"MailLocalizable", @"localizedPluralItemName");
}

- (NSString *)indexManagerEntityName
{
	return @"MailIndexManager";
}

#pragma mark NSNotification observer
- (void)foldersTableViewSelectionDidChange:(NSNotification *)aNotification
{
	NSArray *selectedMailBox = [foldersController selectedObjects];
//	NSManagedObject *
//	if ([selectedMailBox 
}

#pragma mark Action methods

- (IBAction)exportSelection:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setCanChooseDirectories:YES];
	[openPanel setCanChooseFiles:NO];
	[openPanel setCanCreateDirectories:YES];
	[openPanel setAccessoryView:exportFormatView];
	[openPanel setTitle:NSLocalizedStringFromTable(@"Export", @"MailLocalizable", @"exportSheet.title.export")];
	[openPanel setPrompt:NSLocalizedStringFromTable(@"Export", @"MailLocalizable", @"exportSheet.prompt.export")];
	
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	[exportFormatPopUpButton selectItemAtIndex:[userDefaults integerForKey:kWXKMailExportFormatDefaultsKey]];
	[phoneNumberTextField setStringValue:[userDefaults stringForKey:kWXKMailPhoneNumberDefaultsKey]];
	
	[openPanel beginSheetForDirectory:nil
								 file:nil
								types:nil
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(exportSelectionOpenPanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)exportSelectionOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton) {
		WXKMailWindowControllerFileFormat format = [exportFormatPopUpButton indexOfSelectedItem];
		NSString *phoneNumber = [phoneNumberTextField stringValue];
		
		NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
		[userDefaults setObject:phoneNumber forKey:kWXKMailPhoneNumberDefaultsKey];
		[userDefaults setInteger:format forKey:kWXKMailExportFormatDefaultsKey];
		
		NSString *directoryPath = [openPanel filename];
		NSArray *mails = [itemsController selectedObjects];
		
		switch (format) {
			case WXKMailWindowControllerMboxFileFormat:
				[self writeMboxOfMails:mails toDirectory:directoryPath]; break;
			case WXKMailWindowControllerRFC822MessageFileFormat:
				[self writeMailsAsRFC822Message:mails toDirectory:directoryPath]; break;
			case WXKMailWindowControllerVMessageFileFormat:
				[self writeVMessageOfMails:mails toDirectory:directoryPath]; break;
		}
	}
}


#pragma mark Public methods

- (NSDateFormatter *)lightMailDateFormatter
{
	NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
	[dateFormatter setDateFormat:@"yyyy/MM/dd/HH/mm"];
//	[dateFormatter setLenient:YES];
	
	return dateFormatter;
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
	
	if ([[toolbarItem itemIdentifier] isEqualToString:FJDItemsInFolderToolbarDeleteItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Delete", @"MailLocalizable", @"toolbarItem.deleteItem.label")];
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
//		FJDItemsInFolderToolbarNewItemIdentifier,
//		FJDItemsInFolderToolbarDeleteItemIdentifier, 
//		NSToolbarSeparatorItemIdentifier,
		WXKToolbarReceiveItemIdentifier, 
//		WXKToolbarSendItemIdentifier, 
		NSToolbarFlexibleSpaceItemIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier, 
		nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
//		FJDItemsInFolderToolbarNewItemIdentifier,
//		FJDItemsInFolderToolbarDeleteItemIdentifier,
		FJDItemsInFolderToolbarPreviousItemIdentifier,
		FJDItemsInFolderToolbarNextItemIdentifier,
		FJDItemsInFolderToolbarPreviousFolderIdentifier,
		FJDItemsInFolderToolbarNextFolderIdentifier,
		FJDItemsInFolderToolbarDeselectSortIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier,
//		FJDIndexedItemsToolbarReindexSelectionIdentifier,
		WXKToolbarReceiveItemIdentifier,
//		WXKToolbarSendItemIdentifier,
		WXKToolbarAddressUtilityItemIdentifier,
		WXKToolbarBookmarkUtilityItemIdentifier,
		WXKToolbarFileUtilityItemIdentifier,
//		WXKToolbarMailUtilityItemIdentifier,
		NSToolbarPrintItemIdentifier,
		//NSToolbarShowColorsItemIdentifier,
		//NSToolbarShowFontsItemIdentifier, 
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarSeparatorItemIdentifier, 
		NSToolbarSpaceItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier, 
		nil];
}

#pragma mark implementation of NSToolbarItemValidation
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
	if ([theItem action] == @selector(exportSelection:)) {
		return [[itemsController selectedObjects] count] > 0;
	} else {
		return [super validateToolbarItem:theItem];
	}
}

#pragma mark NSMenuValidation informal protocol
- (BOOL)validateMenuItem:(id <NSMenuItem>)theItem
{
{
	if ([theItem action] == @selector(exportSelection:)) {
		return [[itemsController selectedObjects] count] > 0;
	} else {
		return [super validateMenuItem:theItem];
	}
}
}

@end
